#delimit ;
capture log close; 

**************************** ;
**************************** ; 
****************************   This program prices out home health claims using CY2022 payment parameters;
**************************** ;
**************************** ; 

******** Determines when the program started;
local starttime = "$S_TIME";

******** Housekeeping stuff;
clear all;
set matsize 2000;
 
******* Clears the screen;
forvalues x = 1/10 {;
	display _n,_n(400);
	};

*******Sets up the log for the output;
local a1 = substr(c(current_time),1,2);
local a2 = substr(c(current_time),4,2);
local a3 = substr(c(current_time),7,2);

local b     = c(current_date);
local date  = `a1';
local date1 = `a2';
local date2 = `a3';
local date3 = c(current_date);

capture log using "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Forsstrom\CY2024\Repricing (2025 Rule)\Logs\(3) Pricing out 30-day Claims from Simulated 60-Day Episodes and Determining BN Payment (`b')`a1'_`a2'_`a3'.log", replace;

******** Local variables;
local year = 2023;                 * Set this to isolate which episodes you want to keep (based on from date);

local rural_adjA_2019   = 0.015;   * This is the CY2019 rural adjustment value for the "High Utilization" counties;
local rural_adjB_2019   = 0.040;   * This is the CY2019 rural adjustment value for the "Low population density" counties;
local rural_adjC_2019   = 0.030;   * This is the CY2019 rural adjustment value for the "All Other" counties;

local rural_adjA_2020   = 0.005;   * This is the CY2020 rural adjustment value for the "High Utilization" counties;
local rural_adjB_2020   = 0.030;   * This is the CY2020 rural adjustment value for the "Low population density" counties;
local rural_adjC_2020   = 0.020;   * This is the CY2020 rural adjustment value for the "All Other" counties;

local rural_adjA_2021   = 0.000;   * This is the CY2020 rural adjustment value for the "High Utilization" counties;
local rural_adjB_2021   = 0.020;   * This is the CY2020 rural adjustment value for the "Low population density" counties;
local rural_adjC_2021   = 0.010;   * This is the CY2020 rural adjustment value for the "All Other" counties;

local rural_adjA_2022   = 0.000;   * This is the CY2022 rural adjustment value for the "High Utilization" counties;
local rural_adjB_2022   = 0.010;   * This is the CY2022 rural adjustment value for the "Low population density" counties;
local rural_adjC_2022   = 0.000;   * This is the CY2022 rural adjustment value for the "All Other" counties;

local rural_adjA_2023   = 0.000;   * This is the CY2023 rural adjustment value for the "High Utilization" counties;
local rural_adjB_2023   = 0.010;   * This is the CY2023 rural adjustment value for the "Low population density" counties;
local rural_adjC_2023   = 0.000;   * This is the CY2023 rural adjustment value for the "All Other" counties;

local base_2019         = 3154.27; * This is the CY2019 base payment rate;
local base_2020         = 1864.03; * This is the CY2020 base payment rate (PDGM);
*local base_2020        = 3220.79; * This is the CY2020 base payment rate (153);
local base_2021         = 1901.12; * This is the CY2021 base payment rate (PDGM);
local base_2022         = 2031.64; * This is the CY2022 base payment rate (PDGM);
local base_2023         = 2010.69; * This is the CY2023 base payment rate (PDGM);

local outlier_fdl_2019  = 0.51;    * This is the CY2019 FDL;
local outlier_fdl_2020  = 0.56;    * This is the CY2020 FDL (PDGM);
*local outlier_fdl_2020 = 0.51;    * This is the CY2020 FDL (153);
local outlier_fdl_2021  = 0.56;    * This is the CY2021 FDL (PDGM);
local outlier_fdl_2022  = 0.40;    * This is the CY2022 FDL (PDGM);
local outlier_fdl_2023  = 0.35;    * This is the CY2023 FDL (PDGM);

local aid_2019          =  66.34;  * This is CY2019 LUPA rate for Aides;
local mss_2019          = 234.82;  * This is CY2019 LUPA rate for MSS;
local occ_2019          = 161.24;  * This is CY2019 LUPA rate for OCC; 
local phy_2019          = 160.14;  * This is CY2019 LUPA rate for PT; 
local skn_2019          = 146.50;  * This is CY2019 LUPA rate for SN;
local spc_2019          = 174.06;  * This is CY2019 LUPA rate for SLP;

local aid_2020          =  67.78;  * This is CY2020 LUPA rate for Aides;
local mss_2020          = 239.92;  * This is CY2020 LUPA rate for MSS;
local occ_2020          = 164.74;  * This is CY2020 LUPA rate for OCC; 
local phy_2020          = 163.61;  * This is CY2020 LUPA rate for PT; 
local skn_2020          = 149.68;  * This is CY2020 LUPA rate for SN;
local spc_2020          = 177.84;  * This is CY2020 LUPA rate for SLP;

local aid_2021          =  69.11;  * This is CY2021 LUPA rate for Aides;
local mss_2021          = 244.64;  * This is CY2021 LUPA rate for MSS;
local occ_2021          = 167.98;  * This is CY2021 LUPA rate for OCC; 
local phy_2021          = 166.83;  * This is CY2021 LUPA rate for PT; 
local skn_2021          = 152.63;  * This is CY2021 LUPA rate for SN;
local spc_2021          = 181.34;  * This is CY2021 LUPA rate for SLP;

local aid_2022          =  71.04;  * This is CY2022 LUPA rate for Aides;
local mss_2022          = 251.48;  * This is CY2022 LUPA rate for MSS;
local occ_2022          = 172.67;  * This is CY2022 LUPA rate for OCC; 
local phy_2022          = 171.49;  * This is CY2022 LUPA rate for PT; 
local skn_2022          = 156.90;  * This is CY2022 LUPA rate for SN;
local spc_2022          = 186.41;  * This is CY2022 LUPA rate for SLP;

local aid_2023          =  73.93;  * This is CY2022 LUPA rate for Aides;
local mss_2023          = 261.72;  * This is CY2022 LUPA rate for MSS;
local occ_2023          = 179.70;  * This is CY2022 LUPA rate for OCC; 
local phy_2023          = 178.47;  * This is CY2022 LUPA rate for PT; 
local skn_2023          = 163.29;  * This is CY2022 LUPA rate for SN;
local spc_2023          = 194.00;  * This is CY2022 LUPA rate for SLP;

local lupa_add_skn_2019 = 1.8451;  * This is the LUPA add-on factor for SN  (This may be constant from year to year - check);
local lupa_add_pt_2019  = 1.6700;  * This is the LUPA add-on factor for PT  (This may be constant from year to year - check);
local lupa_add_slp_2019 = 1.6266;  * This is the LUPA add-on factor for SLP (This may be constant from year to year - check);

local lupa_add_skn_2020 = 1.8451;  * This is the LUPA add-on factor for SN  (This may be constant from year to year - check);
local lupa_add_pt_2020  = 1.6700;  * This is the LUPA add-on factor for PT  (This may be constant from year to year - check);
local lupa_add_slp_2020 = 1.6266;  * This is the LUPA add-on factor for SLP (This may be constant from year to year - check);

local lupa_add_skn_2021 = 1.8451;  * This is the LUPA add-on factor for SN  (This may be constant from year to year - check);
local lupa_add_pt_2021  = 1.6700;   * This is the LUPA add-on factor for PT  (This may be constant from year to year - check);
local lupa_add_slp_2021 = 1.6266;  * This is the LUPA add-on factor for SLP (This may be constant from year to year - check);

local lupa_add_skn_2022 = 1.8451;  * This is the LUPA add-on factor for SN  (This may be constant from year to year - check);
local lupa_add_pt_2022  = 1.6700;  * This is the LUPA add-on factor for PT  (This may be constant from year to year - check);
local lupa_add_slp_2022 = 1.6266;  * This is the LUPA add-on factor for SLP (This may be constant from year to year - check);
local lupa_add_ot_2022  = 1.6700;  * This is the LUPA add-on factor for OT  (This may be constant from year to year - check);

local lupa_add_skn_2023 = 1.8451;  * This is the LUPA add-on factor for SN  (This may be constant from year to year - check);
local lupa_add_pt_2023  = 1.6700;  * This is the LUPA add-on factor for PT  (This may be constant from year to year - check);
local lupa_add_slp_2023 = 1.6266;  * This is the LUPA add-on factor for SLP (This may be constant from year to year - check);
local lupa_add_ot_2023  = 1.6700;  * This is the LUPA add-on factor for OT  (This may be constant from year to year - check);

local wageadj_2019      = 0.7610;  * This is the CY2019 labor share adjustment;
local wageadj_2020      = 0.7610;  * This is the CY2020 labor share adjustment;
local wageadj_2021      = 0.7610;  * This is the CY2020 labor share adjustment;
local wageadj_2022      = 0.7610;  * This is the CY2022 labor share adjustment;
local wageadj_2023      = 0.7610;  * This is the CY2022 labor share adjustment;

local nrs_2019          =  54.20;  * This is the CY2019 NRS payment rate;
local nrs_2020          =  55.01;  * This is the CY2019 NRS payment rate;

****** Values for CY2019 found here  https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/downloads/MM10992.pdf;
local aidmin_19 = 1.053333333;           * Standardized Per-minute Aide Payment Amounts for CY 2019 (see https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/downloads/MM10992.pdf);
local mssmin_19 = 4.156;                 * Standardized Per-minute MSS  Payment Amounts for CY 2019 (see https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/downloads/MM10992.pdf);
local occmin_19 = 3.423333333;           * Standardized Per-minute OT   Payment Amounts for CY 2019 (see https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/downloads/MM10992.pdf);
local phymin_19 = 3.436666667;           * Standardized Per-minute PT   Payment Amounts for CY 2019 (see https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/downloads/MM10992.pdf);
local sknmin_19 = 3.27;                  * Standardized Per-minute SN   Payment Amounts for CY 2019 (see https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/downloads/MM10992.pdf);
local spcmin_19 = 3.618666667;           * Standardized Per-minute SLP  Payment Amounts for CY 2019 (see https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/downloads/MM10992.pdf);

****** Values for CY2019 found here  https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/Downloads/MM11536.pdf;
local aidmin_20 = 1.076;                 * Standardized Per-minute Aide Payment Amounts for CY 2019 (see https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/Downloads/MM11536.pdf);
local mssmin_20 = 4.24666666666667;      * Standardized Per-minute MSS  Payment Amounts for CY 2019 (see https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/Downloads/MM11536.pdf);
local occmin_20 = 3.49733333333333;      * Standardized Per-minute OT   Payment Amounts for CY 2019 (see https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/Downloads/MM11536.pdf);
local phymin_20 = 3.51066666666667;      * Standardized Per-minute PT   Payment Amounts for CY 2019 (see https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/Downloads/MM11536.pdf);
local sknmin_20 = 3.34133333333333;      * Standardized Per-minute SN   Payment Amounts for CY 2019 (see https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/Downloads/MM11536.pdf);
local spcmin_20 = 3.69733333333333;      * Standardized Per-minute SLP  Payment Amounts for CY 2019 (see https://www.cms.gov/Outreach-and-Education/Medicare-Learning-Network-MLN/MLNMattersArticles/Downloads/MM11536.pdf);

****** Values for CY2021 found here  https://www.cms.gov/files/document/mm12017.pdf;
local aidmin_21 = 1.096984127;           * Standardized Per-minute Aide Payment Amounts for CY 2021 (see https://www.cms.gov/files/document/mm12017.pdf);
local mssmin_21 = 4.329911504;           * Standardized Per-minute MSS  Payment Amounts for CY 2021 (see https://www.cms.gov/files/document/mm12017.pdf);
local occmin_21 = 3.566454352;           * Standardized Per-minute OT   Payment Amounts for CY 2021 (see https://www.cms.gov/files/document/mm12017.pdf);
local phymin_21 = 3.580042918;           * Standardized Per-minute PT   Payment Amounts for CY 2021 (see https://www.cms.gov/files/document/mm12017.pdf);
local sknmin_21 = 3.406919643;           * Standardized Per-minute SN   Payment Amounts for CY 2021 (see https://www.cms.gov/files/document/mm12017.pdf);
local spcmin_21 = 3.77006237;            * Standardized Per-minute SLP  Payment Amounts for CY 2021 (see https://www.cms.gov/files/document/mm12017.pdf);

****** Values for CY2022 found here  https://www.cms.gov/files/document/r11099cp.pdf#page=6;
local aidmin_22 = 1.127619048;           * Standardized Per-minute Aide Payment Amounts for CY 2022 (see https://www.cms.gov/files/document/r11099cp.pdf#page=6);
local mssmin_22 = 4.450973451;           * Standardized Per-minute MSS  Payment Amounts for CY 2022 (see https://www.cms.gov/files/document/r11099cp.pdf#page=6);
local occmin_22 = 3.666029724;           * Standardized Per-minute OT   Payment Amounts for CY 2022 (see https://www.cms.gov/files/document/r11099cp.pdf#page=6);
local phymin_22 = 3.680042918;           * Standardized Per-minute PT   Payment Amounts for CY 2022 (see https://www.cms.gov/files/document/r11099cp.pdf#page=6);
local sknmin_22 = 3.502232143;           * Standardized Per-minute SN   Payment Amounts for CY 2022 (see https://www.cms.gov/files/document/r11099cp.pdf#page=6);
local spcmin_22 = 3.875467775;           * Standardized Per-minute SLP  Payment Amounts for CY 2022 (see https://www.cms.gov/files/document/r11099cp.pdf#page=6);

****** Values for CY2022 found here  https://www.cms.gov/files/document/r11802CP.pdf;
local aidmin_23 = 1.173333333;           * Standardized Per-minute Aide Payment Amounts for CY 2022 (see https://www.cms.gov/files/document/r11802CP.pdf);
local mssmin_23 = 4.632;                 * Standardized Per-minute MSS  Payment Amounts for CY 2022 (see https://www.cms.gov/files/document/r11802CP.pdf);
local occmin_23 = 3.815333333;           * Standardized Per-minute OT   Payment Amounts for CY 2022 (see https://www.cms.gov/files/document/r11802CP.pdf);
local phymin_23 = 3.83;                  * Standardized Per-minute PT   Payment Amounts for CY 2022 (see https://www.cms.gov/files/document/r11802CP.pdf);
local sknmin_23 = 3.644666667;           * Standardized Per-minute SN   Payment Amounts for CY 2022 (see https://www.cms.gov/files/document/r11802CP.pdf);
local spcmin_23 = 4.033333333;           * Standardized Per-minute SLP  Payment Amounts for CY 2022 (see https://www.cms.gov/files/document/r11802CP.pdf);


******** Location of SSS Day files;
local APU_prov_file_2019  = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\Failed APU CY2019 QAO HHCAHPS_claims_addrural_20181109.xlsx";								
local APU_prov_file_2020  = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\HHA_APU_FAILEDHHAS_CY2020_20190910.xlsx";		
local APU_prov_file_2021  = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\HHA_APU_FAILEDHHAS_CY2021_20201215_postappeal.xlsx";						
local APU_prov_file_2022  = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\HHA_APU_FAILEDHHAS_CY2022_20210909.xlsx";	
local APU_prov_file_2023  = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\Failed_APU_CY2023_RERUN_20221128.xlsx";

local HHVBP_2018_file     = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\HHVBP_PY2_PAYMENT_ADJ_20181106.xlsx";								
local HHVBP_2019_file     = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\HHVBP_PY3_PAYMENT_ADJ_20191017.xlsx";
local HHVBP_2020_file     = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\HHVBP_PY4_PAYMENT_ADJ_20201112.xlsx";	************** Note, no HHVBP adjustments again until 2025;	
						
local rural_file          = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\CY 2019-CY 2022 Rural- Add-On Payment Designations.xls";								
local wageindex_2019_file = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\CY 2019 Final HH PPS wage index All Areas-no counties listed.csv";								
local wageindex_2020_file = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\CY2020 508_Compliant_Version_of_All areas - no counties listed.csv";	
local wageindex_2021_file = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\508_Compliant_Version_of_cy_2021_hh_pps_wage_index.csv";	
local wageindex_2022_file = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\All areas - no counties listed of CY_2022__Home_Health_Wage_Index_Final_11_22_21.csv";	
local wageindex_2023_file = "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\CY 2023 Final HH PPS Wage Index.csv";

******** Determines which 30-day periods were part of a therapy 60-day episode - this gets saved to a temporary file and later appended on;
use "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Forsstrom\Repricing (2025 Rule)\hh_output_sim153(therapy).dta", replace;
keep clm_id clm_id_2nd;

preserve;
keep    clm_id_2nd;
drop if clm_id_2nd == .;
rename  clm_id_2nd clm_id;
tempfile therapy;
save   "`therapy'";
restore;

drop clm_id_2nd;
append using "`therapy'";
gen therapy = 1;
duplicates drop;
tempfile therapy_full;
save   "`therapy_full'";


******** Determines which 30-day periods were part of a nontherapy 60-day episode;
use "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Forsstrom\Repricing (2025 Rule)\hh_output_sim153(notherapy).dta", replace;
keep clm_id clm_id_2nd;

preserve;
keep    clm_id_2nd;
drop if clm_id_2nd == .;
rename  clm_id_2nd clm_id;
tempfile notherapy;
save   "`notherapy'";
restore;

drop clm_id_2nd;
append using "`notherapy'";
gen therapy = 0;
duplicates drop;

********* This appends on the prior therapy file - there are 9 periods that appear to be both therapy and non-therapy.  I need to look into this more but am leaving it for now;
append using "`therapy_full'";
distinct clm_id;
duplicates tag clm_id, gen(test);
tab test;
replace therapy = 1 if test == 1;
duplicates drop;
isid clm_id;

tempfile ther_file;
save   "`ther_file'";



****** Merges in APU info;
if `year' == 2019 import excel "`APU_prov_file_`year''", sheet("Failed APU CY2019 QAO HHCAHPS_c") firstrow allstring clear;
if `year' == 2020 import excel "`APU_prov_file_`year''", sheet("Failed APU CY2020")               firstrow allstring clear;
if `year' == 2021 import excel "`APU_prov_file_`year''", sheet("Failed APU CY2021")               firstrow allstring clear;
if `year' == 2022 import excel "`APU_prov_file_`year''", sheet("Failed APU CY2022")               firstrow allstring clear;
if `year' == 2023 import excel "`APU_prov_file_`year''", sheet("Failed_APU")                      firstrow allstring clear;

keep   ccn;
rename ccn provider;

** Creates a flag for whether the provider is in the file;
gen apu = 1;
replace provider = "0" + provider if length(provider) == 5;

** Saves a temp file;
tempfile apu;
save   "`apu'";




****** Importing HHVBP info (2018 for claims in 2019, 2019 for claims in 2020);
import excel "`HHVBP_2018_file'", sheet("Sheet1") firstrow clear;
keep   ccn final_pay_adj;
rename ccn provider;
rename final_pay_adj final_pay_adj2018;

** Saves a temp file;
tempfile hhvbp_2018;
save   "`hhvbp_2018'";

****** Importing 2019 HHVBP info (for claims in 2020);
import excel "`HHVBP_2019_file'", sheet("Sheet1") firstrow clear;
keep   ccn final_pay_adj;
rename ccn provider;
rename final_pay_adj final_pay_adj2019;

** Saves a temp file;
tempfile hhvbp_2019;
save   "`hhvbp_2019'";

****** Importing 2020 HHVBP info (for claims in 2021);
import excel "`HHVBP_2020_file'", sheet("Sheet1") firstrow clear;
keep   ccn final_pay_adj;
rename ccn provider;
rename final_pay_adj final_pay_adj2020;

** Saves a temp file;
tempfile hhvbp_2020;
save   "`hhvbp_2020'";

****** Importing 2021 HHVBP info (for claims in 2022) - There was no HHVBP adjustment this year so everyone just gets a value equal to 1;
use "S:\projects\HH-HSPC\HHA-PPS\2_DATA\HHf22_FINAL_2022\ANFILES\hhf22_150_epioas_exclude.dta", replace;
keep   provider;
duplicates drop;
gen final_pay_adj2021 = 1;

** Saves a temp file;
tempfile hhvbp_2021;
save   "`hhvbp_2021'";

****** Importing 2022 HHVBP info (for claims in 2023) - There was no HHVBP adjustment this year so everyone just gets a value equal to 1;
use "S:\projects\HH-HSPC\HHA-PPS\2_DATA\HHf23_FINAL_2023\ANFILES\hhf23_150_epioas_exclude.dta", replace;
keep   provider;
duplicates drop;
gen final_pay_adj2022 = 1;

** Saves a temp file;
tempfile hhvbp_2022;
save   "`hhvbp_2022'";

************** Imports information on rural counties from 2019 final rule;
import excel "`rural_file'", sheet("Rural counties") firstrow clear;

*** Creates rural categories;
gen     rural_cat = "";
replace rural_cat = "A" if category == "High Utilization";
replace rural_cat = "B" if category == "Low Population Density";
replace rural_cat = "C" if category == "All Other";

*** Variable housekeeping;
destring fips_cnty, replace;
drop name;

****** Tere are a few counties that are listed multiple times (with multiple names but the same category) - this deletes those and makes sure fips_cnty cant be used as an identifier;
duplicates drop;
isid fips_cnty;

****** Saves a temp file;
tempfile rural;
save   "`rural'";




******** This is the wage index from the final rule';
import delimited "`wageindex_`year'_file'", encoding(ISO-8859-2) clear ;
tempfile wage_index;
save   "`wage_index'";

******** Determines the periods actually used for the simulated 60-day episodes;
use          "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Forsstrom\Repricing (2025 Rule)\hh_output_sim153(therapy).dta", replace;
append using "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Forsstrom\Repricing (2025 Rule)\hh_output_sim153(notherapy).dta";
count;
keep *clm_id*;

preserve;
keep    clm_id_2nd;
drop if clm_id_2nd == .;
rename  clm_id_2nd clm_id;
tempfile temp_id;
save   "`temp_id'";
restore;

drop clm_id_2nd;
count;
append using "`temp_id'";
count;
distinct clm_id;
duplicates drop;

tempfile temp_id_full;
save   "`temp_id_full'";



******* Sets the HIPPS for each claim and then attaches the weight;
***** Loads up line items;
if `year' == 2020 use "S:\projects\HH-HSPC\HHA-PPS\2_DATA\HHf20_FINAL_2020\1_PRE_GROUPER\hhf20_150_epioas_exclude.dta", replace;
if `year' == 2021 use "S:\projects\HH-HSPC\HHA-PPS\2_DATA\HHf21_FINAL_2021\hhf21_150_epioas_exclude.dta", replace;
if `year' == 2022 use "S:\projects\HH-HSPC\HHA-PPS\2_DATA\HHf22_FINAL_2022\ANFILES\hhf22_150_epioas_exclude.dta", replace;
if `year' == 2023 use "S:\projects\HH-HSPC\HHA-PPS\2_DATA\HHf23_FINAL_2023\ANFILES\hhf23_150_epioas_exclude.dta", replace;

rename hipps_fnl hipps;

******* Keeps just the observations that are part of the simulated 60-day episodes;
merge 1:1 clm_id using "`temp_id_full'", keepusing(clm_id);
keep if _merge == 3;
drop    _merge;

******* Adds an identifier for whether the 30-day period is therapy or not;
merge 1:1 clm_id using "`ther_file'";
keep if _merge == 3;
drop    _merge;


***************** Merges on weights;
if `year' == 2023 merge m:1 hipps using "S:\projects\HH-HSPC\HHA-PPS\3_USER_pgms\Plotzke\Recalibration (2025 Rule)\Code\Repricing\HIPPS Case-Mix Weight Crosswalk (2023).dta";
drop _merge;
tempfile weights;
save   "`weights'";


**** Creates variables for payday;
gen payday1  = thru_dt - from_dt+1;

****** Merges on capped minutes (and drops old minute variables);
if `year' == 2020 {;
	merge 1:1 abt_link using "S:\projects\HH-HSPC\HHA-PPS\2_DATA\HHf20_FINAL_2020\2_PESKIES\\hhf20_246_cap_min_no_halves.dta";
	keep if _merge == 1 | _merge == 3;
	drop    _merge;
	};

******  This uses the capped minutes to set payment;
drop tot_skn_cmin  tot_occ_cmin tot_phy_cmin tot_spc_cmin aidcmin msscmin;
rename tot_skn_cmin_cap tot_skn_cmin; 
rename tot_occ_cmin_cap tot_occ_cmin;
rename tot_phy_cmin_cap tot_phy_cmin;
rename tot_spc_cmin_cap tot_spc_cmin;
rename aidcmin_cap      aidcmin;
rename msscmin_cap      msscmin;


********* Merges on wage index info;
rename    srv_cbsa ben_cbsa_serv ;
destring  ben_cbsa_serv, replace;
merge m:1 ben_cbsa_serv using "`wage_index'";
keep if _merge == 1 | _merge == 3;
drop    _merge;


********* Merges on info for the rural add-on;
rename srvc_fipstcnty fips_cnty;
destring fips_cnty, replace;
merge m:1 fips_cnty using "`rural'";
keep if _merge == 1 | _merge == 3;
drop    _merge;

***** Not every episode merges to a rural category - this sets the variable to none if a episode doesn't merge;
replace rural_cat = "None" if rural_cat == "";

********* Sets up the rural add-on variable (what the rural add-on percentage amount is);		
gen     rural_add_on = 0;
replace rural_add_on = `rural_adjA_`year'' if rural_cat=="A";   *High utilization;
replace rural_add_on = `rural_adjB_`year'' if rural_cat=="B";   *Low population density;
replace rural_add_on = `rural_adjC_`year'' if rural_cat=="C";   *All Other; 


********* Merges on HHVBP adjustment;
*rename prvdr_num provider;
merge m:1 provider using "`hhvbp_2018'";
keep if _merge ==1 | _merge == 3;
drop    _merge;

merge m:1 provider using "`hhvbp_2019'";
keep if _merge ==1 | _merge == 3;
drop    _merge;

merge m:1 provider using "`hhvbp_2020'";
keep if _merge ==1 | _merge == 3;
drop    _merge;

merge m:1 provider using "`hhvbp_2021'";
keep if _merge ==1 | _merge == 3;
drop    _merge;

merge m:1 provider using "`hhvbp_2022'";
keep if _merge ==1 | _merge == 3;
drop    _merge;

destring final_pay*, replace;
replace final_pay_adj2018 = 1 if final_pay_adj2018 == .;
replace final_pay_adj2019 = 1 if final_pay_adj2019 == .;
replace final_pay_adj2020 = 1 if final_pay_adj2020 == .;
replace final_pay_adj2021 = 1 if final_pay_adj2021 == .;
replace final_pay_adj2022 = 1 if final_pay_adj2022 == .;



****** Merges on APU flag;
merge m:1 provider using "`apu'";
keep if _merge ==1 | _merge == 3;
drop    _merge;


compress;
*save "U:\DUA_050455\_Shared\HH\forsstrom\CY2021\Regroup PDGM Claims under 153 Group\Data\Output\hh_output.dta", replace;
*/;
*use "U:\DUA_050455\_Shared\HH\forsstrom\CY2021\Regroup PDGM Claims under 153 Group\Data\Output\hh_output.dta", replace;
********* Sets up a new local variable so that I use the correct version of variables before;	
if `year' == 2023 local yearshort = 23;
if `year' == 2022 local yearshort = 22;
if `year' == 2021 local yearshort = 21;
if `year' == 2020 local yearshort = 20;
if `year' == 2019 local yearshort = 19;


***** Base payment Rate;
gen base = `base_`year''*(1+rural_add_on);

***** Outlier FDL (with and without quality bonus);
gen fdl = base*`outlier_fdl_`year''*((wage_index`yearshort'*`wageadj_`year'')+(1-`wageadj_`year''));

***** LUPA rates (With and without quality bonus);
gen aidamt = `aid_`year''*(1+rural_add_on);
gen mssamt = `mss_`year''*(1+rural_add_on);
gen occamt = `occ_`year''*(1+rural_add_on);
gen phyamt = `phy_`year''*(1+rural_add_on);
gen sknamt = `skn_`year''*(1+rural_add_on);
gen spcamt = `spc_`year''*(1+rural_add_on);

***** Drops episodes if certain observations are missing;
*gen     wgt                        = wgt_fnl;
drop  if wgt                       == .      ;	
drop  if wage_index`yearshort'     == .      ;
*drop if nrs_wgt                   == .      ;
*drop if prov_cbsa_urbrur          == ""     ;

*****  Sets adjusted base payment for normal episodes (With quality and no-quality bonus);
gen     basepay = 0;
replace basepay = wgt*((wage_index`yearshort'*`wageadj_`year'')+(1-`wageadj_`year''))*base if pep == 0 & lupa == 0;

*****  Sets adjusted base payment for PEP episodes (With quality and no-quality bonus);
replace payday1 = lvisit-fvisit+1;
replace basepay = (round(((payday1)/30),.01)*wgt)*((wage_index`yearshort'*`wageadj_`year'')+(1-`wageadj_`year''))*base if pep == 1 & lupa == 0;
	
***** Sets payment rates for LUPA episodes based on the per-visit rates (With quality and no-quality bonus);	
*** Removes the first visit from the total visit count if the episode satisfies the criteria for a LUPA add-on;	
if `year' >= 2020 rename lupa_add_1st_vis_revhcpc  first_vis;	
replace tot_skn_cvis = tot_skn_cvis - 1 if first_vis == "SKN" & lupa == 1 & lupa_add == 1;
replace tot_phy_cvis = tot_phy_cvis - 1 if first_vis == "PT"  & lupa == 1 & lupa_add == 1;
replace tot_spc_cvis = tot_spc_cvis - 1 if first_vis == "SLP" & lupa == 1 & lupa_add == 1;
replace tot_occ_cvis = tot_occ_cvis - 1 if first_vis == "OT"  & lupa == 1 & lupa_add == 1;

*** Computes the per-visit cost for the LUPA payment (not including the LUPA add-on visit);
gen     pervisitcost = 0;
replace pervisitcost = ((wage_index`yearshort'*`wageadj_`year'')+(1-`wageadj_`year''))*(aidcvis*aidamt + msscvis*mssamt       + tot_occ_cvis*occamt       + tot_phy_cvis*phyamt       + tot_skn_cvis*sknamt       + tot_spc_cvis*spcamt);

*** Add's on the adjusted per-visit cost for the LUPA payment if the LUPA add-on criteria is satisfier;
replace pervisitcost = pervisitcost + ((wage_index`yearshort'*`wageadj_`year'')+(1-`wageadj_`year''))*sknamt*`lupa_add_skn_`year'' if first_vis == "SKN" & pep == 0 & lupa == 1 & lupa_add == 1;
replace pervisitcost = pervisitcost + ((wage_index`yearshort'*`wageadj_`year'')+(1-`wageadj_`year''))*phyamt*`lupa_add_pt_`year''  if first_vis == "PT"  & pep == 0 & lupa == 1 & lupa_add == 1;
replace pervisitcost = pervisitcost + ((wage_index`yearshort'*`wageadj_`year'')+(1-`wageadj_`year''))*spcamt*`lupa_add_slp_`year'' if first_vis == "SLP" & pep == 0 & lupa == 1 & lupa_add == 1;
replace pervisitcost = pervisitcost + ((wage_index`yearshort'*`wageadj_`year'')+(1-`wageadj_`year''))*occamt*`lupa_add_ot_`year''  if first_vis == "OT"  & pep == 0 & lupa == 1 & lupa_add == 1;

*** Add's back on the first visit from the total visit count if it had been subtracted earlier;
replace tot_skn_cvis = tot_skn_cvis + 1 if first_vis == "SKN" & lupa == 1 & lupa_add == 1;
replace tot_phy_cvis = tot_phy_cvis + 1 if first_vis == "PT"  & lupa == 1 & lupa_add == 1;
replace tot_spc_cvis = tot_spc_cvis + 1 if first_vis == "SLP" & lupa == 1 & lupa_add == 1;
replace tot_occ_cvis = tot_occ_cvis + 1 if first_vis == "OT"  & lupa == 1 & lupa_add == 1;
	

****** Sets NRS payment (With quality and no-quality bonus);
gen     nrspay = 0;
*replace nrspay = nrs_wgt*`nrs_`year''*(1+rural_add_on)   if lupa == 0;
*replace nrspay = nrspay*(payday1)/60                     if  pep == 1;


****** Sets Outlier Threshold;
gen out_thresh = basepay + fdl + nrspay;

****** Calculated the imputed cost;
gen outcost = (wage_index`yearshort'*`wageadj_`year''+ 1 - `wageadj_`year'')*(1+rural_add_on)*(aidcmin*`aidmin_`yearshort'' + msscmin*`mssmin_`yearshort'' + tot_occ_cmin*`occmin_`yearshort'' + tot_phy_cmin*`phymin_`yearshort'' + tot_skn_cmin*`sknmin_`yearshort'' + tot_spc_cmin*`spcmin_`yearshort'');
******  If per visit amount is greater than Outlier Threshold, apply the outlier payment;
gen     outpay = 0;
replace outpay = 0.8*(outcost - out_thresh) if outcost >= out_thresh;
***** Makes sure LUPAs dont get any outlier payments (some periods with long visits can trigger the outlier threshold);
replace outpay = 0 if lupa == 1;

****** Outlier cap;
*	gen outold1=(basepay_19_old+nrspay_19)*(1/9);
*	replace outpay_19_old=min(outpay_19_old,outold1) if outcost_19_old >= out_thresh_19_old ;

****** Adds base payment to NRS payment and outlier payment;
egen    totpay_nooutlier = rowtotal(basepay nrspay);

****** Renames final pay adjust variables so it aligns with the year;
rename final_pay_adj2022 final_pay_adj2023;
rename final_pay_adj2021 final_pay_adj2022;
rename final_pay_adj2020 final_pay_adj2021;
rename final_pay_adj2019 final_pay_adj2020;
rename final_pay_adj2018 final_pay_adj2019;

********** Checks payments (Applies sequestration and HHVBP adjustment);
if `year' == 2023 {;
	gen     tot_pmt = 0;
	replace tot_pmt = round((totpay_nooutlier + outpay)*0.98*final_pay_adj20`yearshort',.01)              ;
	replace tot_pmt = round(pervisitcost*0.98*final_pay_adj20`yearshort',.01)                if lupa == 1 ;

	};

if `year' == 2022 {;
	gen     tot_pmt = 0;
	replace tot_pmt = round((totpay_nooutlier + outpay)*0.98*final_pay_adj20`yearshort',.01) if             month(thru_dt) >= 7;
	replace tot_pmt = round(pervisitcost*0.98*final_pay_adj20`yearshort',.01)                if lupa == 1 & month(thru_dt) >= 7;

	replace tot_pmt = round((totpay_nooutlier + outpay)*0.99*final_pay_adj20`yearshort',.01) if             month(thru_dt) >= 4 & month(thru_dt) <= 6;
	replace tot_pmt = round(pervisitcost*0.99*final_pay_adj20`yearshort',.01)                if lupa == 1 & month(thru_dt) >= 4 & month(thru_dt) <= 6;

	replace tot_pmt = round((totpay_nooutlier + outpay)*final_pay_adj20`yearshort',.01)      if             month(thru_dt) <= 3;
	replace tot_pmt = round(pervisitcost*final_pay_adj20`yearshort',.01)                     if lupa == 1 & month(thru_dt) <= 3;
	};

if `year' == 2021 {;
	gen     tot_pmt = 0;
	replace tot_pmt = round((totpay_nooutlier + outpay)*final_pay_adj20`yearshort',.01)      ;
	replace tot_pmt = round(pervisitcost*final_pay_adj20`yearshort',.01)         if lupa == 1;
	};

if `year' == 2020 {;
	gen     tot_pmt = 0;
	replace tot_pmt = round((totpay_nooutlier + outpay)*0.98*final_pay_adj20`yearshort',.01) if month(thru_dt) < 5;
	replace tot_pmt = round(pervisitcost*0.98*final_pay_adj20`yearshort',.01)                if lupa == 1 & month(thru_dt) < 5;

	replace tot_pmt = round((totpay_nooutlier + outpay)*final_pay_adj20`yearshort',.01)      if month(thru_dt) >= 5;
	replace tot_pmt = round(pervisitcost*final_pay_adj20`yearshort',.01)                     if lupa == 1 & month(thru_dt) >= 5;
	};
	
if `year' == 2019 {;
	gen     tot_pmt = 0;
	replace tot_pmt = round((totpay_nooutlier + outpay)*0.98*final_pay_adj20`yearshort',.01);
	replace tot_pmt = round(pervisitcost*0.98*final_pay_adj20`yearshort',.01)                if lupa == 1 ;
	};


gen diff      = pmt_amt-(tot_pmt);
gen diff_pcnt = pmt_amt/(tot_pmt);

summ tot_pmt;


******** This checks the payments per episode.  It determines how close the simulated payment that we calculate is to the actual payment on the claim;
******** Information is broken down by type of episode (Normal, outlier, LUPA, PEP, all combined) and by different categories of closeness (e.g. within $1, within $10, etc);
******** To make the comparison easier, we drop all the 60-day episodes from providers that fail the APU requirement;
forvalues list = 1/5 {;
	preserve;
	****************** COMMENT THIS LINE OUT IF YOU WANT TO KEEP THE APU CLAIMS;
	drop if apu == 1;
	
	if `list' == 1 drop if outlier == 1 | lupa == 1 | pep == 1;
	if `list' == 2 keep if outlier == 1 & lupa == 0 & pep == 0;
	if `list' == 3 keep if outlier == 0 & lupa == 1 & pep == 0;
	if `list' == 4 keep if outlier == 0 & lupa == 0 & pep == 1;
	if `list' == 5 drop if outlier == 23432423432;
	
	summ diff, detail;
	count;
	local a = `r(N)';

	count if diff >= -1 & diff <= 1;
	local b1      = `r(N)';
	local b1_pcnt = `b1'/`a';

	count if diff >= -10 & diff <= 10;
	local b2      = `r(N)';
	local b2_pcnt = `b2'/`a';

	count if diff >= -100 & diff <= 100;
	local b3      = `r(N)';
	local b3_pcnt = `b3'/`a'; 

	summ diff_pcnt, detail;

	count if diff_pcnt >= .98 & diff <= 1.02;
	local c1      = `r(N)';
	local c1_pcnt = `c1'/`a';

	count if diff_pcnt >= .99 & diff <= 1.01;
	local c2      = `r(N)';
	local c2_pcnt = `c2'/`a';

	count if diff_pcnt >= .999 & diff <= 1.001;
	local c3      = `r(N)';
	local c3_pcnt = `c3'/`a';


	if `list' == 1 display "Normal";
	if `list' == 2 display "Outlier";
	if `list' == 3 display "LUPA";
	if `list' == 4 display "PEP";
	if `list' == 5 display "All";
	display "Total Episodes: `a'";
	display "Episodes matched within $1  : `b1'				`b1_pcnt'";
	display "Episodes matched within $10 : `b2'				`b2_pcnt'";
	display "Episodes matched within $100: `b3'				`b3_pcnt'";
	display "";
	display "Episodes matched within 2.0%: `c1'				`c1_pcnt'";
	display "Episodes matched within 1.0%: `c2'				`c2_pcnt'";
	display "Episodes matched within 0.1%: `c3'				`c3_pcnt'";
	restore;
};

*/;






























forvalues iter_samp = 1/1 {;
preserve;

display "Total number of Periods before exclusions";
count;

if `iter_samp' == 1 display "Keep all periods";
if `iter_samp' == 2 display "Keep therapy";
if `iter_samp' == 3 display "Keep non-therapy";

if `iter_samp' == 1 keep if therapy == 1 | therapy == 0;
if `iter_samp' == 2 keep if therapy == 1;
if `iter_samp' == 3 keep if therapy == 0;

display "Total number of Periods after exclusions";
count;

***************************** Insert the FDL's you want to try out - make sure it matches to the year you want;
if `iter_samp' == 1 local fdllist ".35";
if `iter_samp' == 2 local fdllist ".68";
if `iter_samp' == 3 local fdllist ".38";

foreach outlier_fdl_`year' of local fdllist {;
	local outlier_fdl_`year' = round(`outlier_fdl_`year'',.01);

	******************************** This is the part where I figure out the budget neutral payment rates;
	local impact = 1;
	local impact_diff = 50000;
	local iter   = 1;
	local start153    = 2031.64;
	local base_2020   = 1864.03; * This is the CY2020 base payment rate (PDGM);
	local base_2021   = 1901.12; * This is the CY2021 base payment rate (PDGM);
	local base_2022   = 2031.64; * This is the CY2022 base payment rate (PDGM);
	local base_2023   = 2010.69; * This is the CY2023 base payment rate (PDGM);
	

	while `impact_diff' >= 30000 | `impact_diff' <= -30000 {;

		***** Base payment Rate;
		replace base = `base_`year''*(1+rural_add_on);

		***** Outlier FDL (with and without quality bonus);
		replace fdl = base*`outlier_fdl_`year''*((wage_index`yearshort'*`wageadj_`year'')+(1-`wageadj_`year''));

		***** LUPA rates (With and without quality bonus);
		replace aidamt = `aid_`year''*(1+rural_add_on);
		replace mssamt = `mss_`year''*(1+rural_add_on);
		replace occamt = `occ_`year''*(1+rural_add_on);
		replace phyamt = `phy_`year''*(1+rural_add_on);
		replace sknamt = `skn_`year''*(1+rural_add_on);
		replace spcamt = `spc_`year''*(1+rural_add_on);

		***** Drops episodes if certain observations are missing;
		*gen     wgt                       = wgt_fnl    ;
		 drop if wgt                      == .          ;	
		 drop if wage_index`yearshort'    == .          ;
		*drop if nrs_wgt                  == .          ;
		*drop if prov_cbsa_urbrur         == ""         ;


		*****  Sets adjusted base payment for normal episodes (With quality and no-quality bonus);
		replace basepay = 0;
		replace basepay = wgt*((wage_index`yearshort'*`wageadj_`year'')+(1-`wageadj_`year''))*base if pep == 0 & lupa == 0;

		*****  Sets adjusted base payment for PEP episodes (With quality and no-quality bonus);
		replace payday1 = lvisit-fvisit+1;
		replace basepay = (round(((payday1)/30),.01)*wgt)*((wage_index`yearshort'*`wageadj_`year'')+(1-`wageadj_`year''))*base if pep == 1 & lupa == 0;
	
									   
		***** Sets payment rates for LUPA episodes based on the per-visit rates (With quality and no-quality bonus);	

		*** Removes the first visit from the total visit count if the episode satisfies the criteria for a LUPA add-on;		
		*rename lupa_add_1st_vis_revhcpc  first_vis;
		replace tot_skn_cvis = tot_skn_cvis - 1 if first_vis == "SKN" & lupa == 1 & lupa_add == 1;
		replace tot_phy_cvis = tot_phy_cvis - 1 if first_vis == "PT"  & lupa == 1 & lupa_add == 1;
		replace tot_spc_cvis = tot_spc_cvis - 1 if first_vis == "SLP" & lupa == 1 & lupa_add == 1;

		*** Computes the per-visit cost for the LUPA payment (not including the LUPA add-on visit);
		replace pervisitcost = 0;
		replace pervisitcost = ((wage_index`yearshort'*`wageadj_`year'')+(1-`wageadj_`year''))*(aidcvis*aidamt + msscvis*mssamt       + tot_occ_cvis*occamt       + tot_phy_cvis*phyamt       + tot_skn_cvis*sknamt       + tot_spc_cvis*spcamt);

		*** Add's on the adjusted per-visit cost for the LUPA payment if the LUPA add-on criteria is satisfier;
		replace pervisitcost = pervisitcost + ((wage_index`yearshort'*`wageadj_`year'')+(1-`wageadj_`year''))*sknamt*`lupa_add_skn_`year'' if first_vis == "SKN" & pep == 0 & lupa == 1 & lupa_add == 1;
		replace pervisitcost = pervisitcost + ((wage_index`yearshort'*`wageadj_`year'')+(1-`wageadj_`year''))*phyamt*`lupa_add_pt_`year''  if first_vis == "PT"  & pep == 0 & lupa == 1 & lupa_add == 1;
		replace pervisitcost = pervisitcost + ((wage_index`yearshort'*`wageadj_`year'')+(1-`wageadj_`year''))*spcamt*`lupa_add_slp_`year'' if first_vis == "SLP" & pep == 0 & lupa == 1 & lupa_add == 1;

		*** Add's back on the first visit from the total visit count if it had been subtracted earlier;
		replace tot_skn_cvis = tot_skn_cvis + 1 if first_vis == "SKN" & lupa == 1 & lupa_add == 1;
		replace tot_phy_cvis = tot_phy_cvis + 1 if first_vis == "PT"  & lupa == 1 & lupa_add == 1;
		replace tot_spc_cvis = tot_spc_cvis + 1 if first_vis == "SLP" & lupa == 1 & lupa_add == 1;
							

		****** Sets NRS payment (With quality and no-quality bonus);
		replace     nrspay = 0;
		*replace nrspay = nrs_wgt*`nrs_`year''*(1+rural_add_on)   if lupa == 0;
		*replace nrspay = nrspay*(payday1)/60                     if  pep == 1;

		****** Adds base payment to NRS payment and outlier payment;
		drop totpay_nooutlier;
		egen totpay_nooutlier = rowtotal(basepay nrspay);
		
		****** Sets Outlier Threshold;
		replace out_thresh = basepay + fdl + nrspay;

		****** Calculated the imputed cost;
		replace outcost = (wage_index`yearshort'*`wageadj_`year''+ 1 - `wageadj_`year'')*(1+rural_add_on)*(aidcmin*`aidmin_`yearshort'' + msscmin*`mssmin_`yearshort'' + tot_occ_cmin*`occmin_`yearshort'' + tot_phy_cmin*`phymin_`yearshort'' + tot_skn_cmin*`sknmin_`yearshort'' + tot_spc_cmin*`spcmin_`yearshort'');
		******  If per visit amount is greater than Outlier Threshold, apply the outlier payment;
		replace outpay = 0;
		replace outpay = 0.8*(outcost - out_thresh) if outcost >= out_thresh;
		summ outcost out_thresh outpay;
		***** Makes sure LUPAs dont get any outlier payments (some periods with long visits can trigger the outlier threshold);
		replace outpay = 0 if lupa == 1;

		
		gen     pervisitcost_lupa = pervisitcost if lupa == 1;
		replace pervisitcost_lupa = 0            if pervisitcost_lupa == .;
		sum     pervisitcost_lupa;
		local lupa_pmt = `r(sum)';
		
		
		****** Outlier cap;
		**** Total non-outlier payments for each observation;
		egen non_out = rowtotal(totpay_nooutlier pervisitcost_lupa);
		**** For each observation, Create a variable for the HHA total of non-outlier payments;
		by provider, sort: egen non_out_hha = total(non_out);
		**** For each observation, Create a variable for the HHA total of outlier payments;
		by provider, sort: egen     out_hha = total(outpay);
		summ non_out non_out_hha out_hha;
		**** For each observation, determine the HHA specific outlier threshold;
		replace non_out_hha = non_out_hha*1/9;
		summ non_out_hha;
		
		display "Number of outlier 30-day periods";
		count if outpay > 0 & outpay ~= . ;
		display "Number of outlier 30-day periods from a HHA over the 10% cap";
		count if out_hha > non_out_hha  & outpay > 0 & outpay ~= .;
		
		**** For each observation, keep the outlier payments as is or multiply the outlier payments by the ratio of the HHA specific outlier threshold divided by the HHA outlier payments;
		replace outpay = min(outpay*1, outpay*(non_out_hha/out_hha));
		summ outpay;
        **** Drops unneeded variables;
		drop non_out non_out_hha out_hha;
		
		*	gen outold1=(basepay_19_old+nrspay_19)*(1/9);
		*	replace outpay_19_old=min(outpay_19_old,outold1) if outcost_19_old >= out_thresh_19_old ;

		****** Adds base payment to NRS payment and outlier payment;
		drop totpay_nooutlier;
		egen totpay_nooutlier = rowtotal(basepay nrspay);

		/*;
		********** Checks payments (Applies sequestration and HHCVB adjustment);
		replace tot_pmt = 0;
		replace tot_pmt = round((totpay_nooutlier + outpay)*0.98*final_pay_adj2019,.01) if             month(thru_dt) < 5;
		replace tot_pmt = round(pervisitcost*0.98*final_pay_adj2019,.01)                if lupa == 1 & month(thru_dt) < 5;

		replace tot_pmt = round((totpay_nooutlier + outpay)*final_pay_adj2019,.01)      if             month(thru_dt) >= 5;
		replace tot_pmt = round(pervisitcost*final_pay_adj2019,.01)                     if lupa == 1 & month(thru_dt) >= 5;
		*/;

		********** Checks payments (DOES NOT apply sequestration and HHVBP adjustment);
		replace tot_pmt = 0;
		replace tot_pmt = round((totpay_nooutlier + outpay),.01)             ;
		replace tot_pmt = round(pervisitcost,.01)                if lupa == 1;
		
		replace diff      = pmt_amt-(tot_pmt);
		replace diff_pcnt = pmt_amt/(tot_pmt);
		summ  tot_pmt;
		local tot_pmt_adj = `r(sum)';
		

		summ totpay_nooutlier;
		local result1 = `r(sum)';
		

		
		
		egen tot_pmt_noadj = rowtotal(totpay_nooutlier outpay pervisitcost_lupa);
		sum tot_pmt_noadj;
		local result3 = `r(sum)';
		
		tab therapy;
		summ tot_pmt_noadj if pep == 0 & lupa == 0 & outlier == 0;
		return list;
		
		
		******** Sets the Outlier variable correctly;
		replace outlier = outpay > 0 & outpay ~= .;
		
		
		******** Creates summaries of unadjusted payment amounts;							
		summ outpay if outlier == 1;							
		local a1 = `r(N)';							
		local a2 = `r(mean)';							
		local a3 = `r(sum)';							
									
		summ tot_pmt_noadj          if outlier == 0 & pep == 0 & lupa == 1;							
		local b1 = `r(N)';							
		local b2 = `r(mean)';							
		local b3 = `r(sum)';							
									
		summ tot_pmt_noadj          if outlier == 0 & pep == 1 & lupa == 0;							
		local c1 = `r(N)';							
		local c2 = `r(mean)';							
		local c3 = `r(sum)';							
									
		summ tot_pmt_noadj          if outlier == 1 & pep == 1 & lupa == 0;							
		local d1 = `r(N)';							
		local d2 = `r(mean)';							
		local d3 = `r(sum)';							
									
		summ tot_pmt_noadj          if outlier == 1 & pep == 0 & lupa == 0;							
		local e1 = `r(N)';							
		local e2 = `r(mean)';							
		local e3 = `r(sum)';							
									
		summ tot_pmt_noadj          if outlier == 0 & pep == 0 & lupa == 0;							
		local f1 = `r(N)';							
		local f2 = `r(mean)';							
		local f3 = `r(sum)';							
									
		summ tot_pmt_noadj;							
		local g1 = `r(N)';							
		local g2 = `r(mean)';							
		local g3 = `r(sum)';							
									
		summ wgt if lupa == 0;							
		local h1 = `r(N)';							
		local h2 = `r(mean)';	

		summ tot_pmt_noadj          if outlier == 0 & pep == 0 & lupa == 0 & tot_phy_cvis == 0 & tot_occ_cvis == 0 & tot_spc_cvis == 0;							
		local i1 = `r(N)';							
		local i2 = `r(mean)';							
		local i3 = `r(sum)';						

		summ tot_pmt_noadj          if outlier == 0 & pep == 0 & lupa == 0 & (tot_phy_cvis > 0 | tot_occ_cvis > 0 | tot_spc_cvis > 0);							
		local j1 = `r(N)';							
		local j2 = `r(mean)';							
		local j3 = `r(sum)';						

							
		forvalues times = 1/1 {;					
			display "Unadjusted payments";						
			display "            Outlier Payments:    `a1'		`a2'		`a3'";		
			display "            LUPA    Payments:    `b1'		`b2'		`b3'";		
			display "   PEP (No outlier) Payments:    `c1'		`c2'		`c3'";		
			display "      PEP + Outlier Payments:    `d1'		`d2'		`d3'";		
			display "   Outlier (No PEP) Payments:    `e1'		`e2'		`e3'";		
			display "             Normal Payments:    `f1'		`f2'		`f3'";		
			display "                All Payments:    `g1'		`g2'		`g3'";		
			display "    Avg Weight for non-LUPAs:    `h1'      `h2'            ";						
			display "Normal Payments (No therapy):    `i1'		`i2'		`i3'";	
			display "   Normal Payments (Therapy):    `j1'		`j2'		`j3'";	
		};

		save "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Forsstrom\Repricing (2025 Rule)\Repriced 30_dayPeriods(`date3')`date'_`date1'_`date2'.dta", replace;
		drop pervisitcost_lupa tot_pmt_noadj;
			
		summ outpay;
		local result2 = `r(sum)';
		local outlier_pcnt = `result2'/`result3';
		********************* Put the total payments from the "(2) Repricing Regrouped Claims" program below - this is the total payments that this program is trying to equal;
		if `iter_samp' == 1 local group153 =  12165126616.20033;
		if `iter_samp' == 2 local group153 = .;
		if `iter_samp' == 3 local group153 = .;
		
		display "iter: `iter' with FDL of `outlier_fdl_`year''";
		local iter = `iter' + 1;
		local impact = (`result3'-`group153')/`group153';
		local impact_diff = (`result3'-`group153');
		local outlier_pcnt = `result2'/`result3';

		display "Payment rate: `base_`year''";

		display "Non outlier payments: `result1'";
		display "outlier payments: `result2'";
		display "LUPA payments: `lupa_pmt'";
		display "Total payments - not adjusted: `result3'";
		display "Total payments - not adjusted (153 group): `group153'";
		display "Total payments - adjusted: `tot_pmt_adj'";
		display "Outlier_pcnt: `outlier_pcnt'";
		display "PDGM FDL: `outlier_fdl_`year''";
		display "Impact: `impact'";
		display "Impact difference: `impact_diff'";
		local adjust_factor = `base_`year''/`start153';
		local final_start = `base_`year'';
		local base_`year' = round(`base_`year''+(-1)*`impact'*`base_`year'',.01);
		display "Adjust factor: `adjust_factor'";
		display "Next Payment rate:  `base_`year''";
		
		};

	display "Number of periods:";
	count;
	display "THIS IS THE END OF RESULTS FOR FDL of `outlier_fdl_`year''!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!";
	display "This is the results for iter sample: `iter_samp'";
	};
restore;
};

datasig;



#delimit ;
use "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Forsstrom\Repricing (2025 Rule)\Repriced 30_dayPeriods(`date3')`date'_`date1'_`date2'.dta", replace;
keep abt_link bene_id clm_id provider from_dt thru_dt aidcvis msscvis tot_skn_cvis tot_phy_cvis tot_occ_cvis tot_spc_cvis 
     aidcmin msscmin tot_occ_cmin tot_phy_cmin tot_skn_cmin tot_spc_cmin first_vis lupa_add pep outlier hipps lupa wgt 
	 wage_index`yearshort' rural_cat rural_add_on outpay tot_pmt_noadj  occ_dt_50;

order abt_link bene_id clm_id provider from_dt thru_dt aidcvis msscvis tot_skn_cvis tot_phy_cvis tot_occ_cvis tot_spc_cvis 
      aidcmin msscmin tot_occ_cmin tot_phy_cmin tot_skn_cmin tot_spc_cmin first_vis lupa_add pep outlier hipps lupa wgt 
	  wage_index`yearshort' rural_cat rural_add_on outpay tot_pmt_noadj occ_dt_50;

rename abt_link abt_link;
rename bene_id bene_id ;
rename provider provider ;
rename from_dt from_dt ;
rename thru_dt thru_dt ;
rename wage_index`yearshort' wage_index`yearshort';
rename clm_id clm_id;
rename lupa lupa ;
rename hipps hipps ;
rename wgt weight ;
rename pep pep ;
rename outlier outlier ;
rename tot_pmt_noadj pmt_amt ;
rename outpay pmt_amt_out ;
rename tot_skn_cvis skn_cvis ;
rename tot_phy_cvis phy_cvis ;
rename tot_occ_cvis occ_cvis ;
rename tot_spc_cvis spc_cvis ;
rename aidcvis aid_cvis ;
rename msscvis mss_cvis ;
rename tot_skn_cmin skn_cmin ;
rename tot_phy_cmin phy_cmin ;
rename tot_occ_cmin occ_cmin ;
rename tot_spc_cmin spc_cmin ;
rename aidcmin aid_cmin ;
rename msscmin mss_cmin ;
rename first_vis first_vis;
rename lupa_add lupa_add;
rename rural_cat rural_cat;
rename rural_add_on rural_add_on;
order abt_link bene_id provider from_dt thru_dt wage_index`yearshort' clm_id lupa hipps weight pep outlier pmt_amt pmt_amt_out skn_cvis phy_cvis occ_cvis spc_cvis aid_cvis mss_cvis skn_cmin phy_cmin occ_cmin spc_cmin aid_cmin mss_cmin first_vis lupa_add rural_cat rural_add_on;

#delimit ;
label var abt_link "ABT: EPISODE UNIQUE IDENTIFIER";
label var bene_id "Beneficiary ID";
label var provider "CMS Certification Number (CCN)";
label var from_dt "Claim from date";
label var thru_dt "Claim thru date";
label var wage_index`yearshort' "Wage index that would be applied to the claim (20`yearshort')";
label var clm_id "Claim ID";
label var lupa "Flag for whether 30-day period is a LUPA";
label var hipps "The HIPPS of the 30-day period";
label var weight "PDGM case-mix weight";
label var pep "Flag for whether the 30-day period is a PEP";
label var outlier "Flag for whether the 30-day period is an outlier ";
label var pmt_amt "Simulated Repriced 20`yearshort' PDGM payment amount (including outlier payment)";
label var pmt_amt_out "Simulated Repriced 20`yearshort' PDGM outlier payment";
label var skn_cvis "Nursing Visits";
label var phy_cvis "Physical Therapy Visits";
label var occ_cvis "Occupational Therapy Visits";
label var spc_cvis "Speech Language Pathology Visits";
label var aid_cvis "Aide Visits";
label var mss_cvis "Medical Social Services Visits";
label var skn_cmin "Nursing Minutes";
label var phy_cmin "Physical Therapy Minutes";
label var occ_cmin "Occupational Therapy Minutes";
label var spc_cmin "Speech Language Pathology Minutes";
label var aid_cmin "Aide Minutes";
label var mss_cmin "Medical Social Services Minutes";
label var first_vis "Indicator for whether first visit was SKN/PT/SLP (for LUPA add-on)";
label var lupa_add "Flag for LUPA add-on payment";
label var rural_cat "Rural Category for Rural Add-on Payment";
label var rural_add_on "Rural Add-on Percentage";
labe var  occ_dt_50 "OASIS Assessment Date";

**** clean up;
#delimit ;
replace weight = round(weight,.0001);
replace wage_index`yearshort' = round(wage_index`yearshort',.0001);
replace first_vis = "" if lupa_add ~= 1;
replace lupa_add = 0 if lupa == 0;

recast double wage_index`yearshort' weight rural_add_on;

replace wage_index`yearshort' = round(wage_index`yearshort',.0001);
replace weight = round(weight,.0001);
replace rural_add_on = round(rural_add_on,.0001);
label var spc_cvis "Speech Language Pathology Visits";
label var spc_cmin "Speech Language Pathology Minutes";	 	  

compress;
mdesc;
desc;
sort bene_id clm_id;
save "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Forsstrom\Repricing (2025 Rule)\LDS_30day(`date3')`date'_`date1'_`date2'.dta", replace;

preserve;
drop abt_link;
save "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Forsstrom\Repricing (2025 Rule)\LDS_30day(CMS)(`date3')`date'_`date1'_`date2'.dta", replace;
datasig;
restore;


gen eps = 1;
gen rural = rural_add_on > 0 & rural_add_on ~= .;
gen hipps_short = substr(hipps,1,4);


collapse (sum) eps (mean) rural pmt_amt pmt_amt_out outlier pep lupa weight *cvis* *cmin*, by(hipps);
summ eps;
gen pcnt = eps/`r(sum)';

order hipps eps pcnt rural pmt_amt pmt_amt_out pep lupa weight phy_cvis occ_cvis spc_cvis skn_cvis mss_cvis aid_cvis phy_cmin occ_cmin spc_cmin skn_cmin mss_cmin aid_cmin;
#delimit ;
export excel     using "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Forsstrom\Repricing (2025 Rule)\Public Facing 30-Day(`date3')`date'_`date1'_`date2'.xlsx", firstrow(variables) replace;
export delimited using "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\forsstrom\Repricing (2025 Rule)\Public Facing 30-Day(`date3')`date'_`date1'_`date2'.csv", replace;
datasig;
	
*******************;
*** Diagnostics;
*******************;
use "S:\projects\HH-HSPC\HHA-PPS\2_DATA\_USER_Data\Forsstrom\Repricing (2025 Rule)\LDS_30day(`date3')`date'_`date1'_`date2'.dta", replace;

****** Info on episodes;
summ, sep(0);
desc;
distinct;

******** Make sure there is 432 HIPPS;
codebook hipps;


*order lupa lupa_add first_vis rural_add pep outlier diff diff_pcnt clm_pmt_amt tot_pmt *cvis* wage_index20;
*********  Program ends;
datasig;
display "Start: `starttime'";
display "End: " "$S_TIME";
log close;	